/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Date;
import jclass.bwt.JCSerializable;
import jclass.chart.AnnotationHandler;
import jclass.chart.AxisHandler;
import jclass.chart.ChartCanvas;
import jclass.chart.ChartDataView;
import jclass.chart.ChartRegion;
import jclass.chart.ChartText;
import jclass.chart.DerivedDouble;
import jclass.chart.DerivedInt;
import jclass.chart.DerivedString;
import jclass.chart.ErrorDialog;
import jclass.chart.Extents;
import jclass.chart.JCAxisFormula;
import jclass.chart.JCAxisTitle;
import jclass.chart.JCChartArea;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCFillStyle;
import jclass.chart.JCLabelGenerator;
import jclass.chart.JCLineStyle;
import jclass.chart.JCValueLabel;
import jclass.chart.MinMax;
import jclass.util.JCVector;

public class JCAxis
extends ChartRegion
implements JCSerializable {
    int gap = 3;
    protected JCAxisTitle title;
    DerivedDouble min = new DerivedDouble(0.0, true);
    DerivedDouble max = new DerivedDouble(0.0, true);
    DerivedDouble origin = new DerivedDouble(0.0, true);
    DerivedInt originPlacement = new DerivedInt(0, true);
    DerivedInt placement = new DerivedInt(0, true);
    JCChartStyle gridStyle;
    DerivedDouble gridSpacing = new DerivedDouble(0.0, true);
    boolean gridIsShowing = false;
    protected JCAxisFormula formula;
    boolean isEditable = true;
    boolean isLogarithmic = false;
    boolean isReversed = false;
    boolean isVertical = false;
    int annotationRotation;
    JCAxis placementAxis;
    double placementLocation;
    JCLabelGenerator labelGenerator;
    boolean axisDrawn = false;
    long timeUnit = 1000L;
    Date timeBase;
    DerivedString timeFormat = new DerivedString("", true);
    int tickLength = 4;
    JCChartArea chartArea;
    double step = 1.0;
    static int axisNum;
    boolean hasBar = false;
    public static final long SECONDS = 1000L;
    public static final long MINUTES = 60000L;
    public static final long HOURS = 3600000L;
    public static final long DAYS = 86400000L;
    public static final long WEEKS = 604800000L;
    public static final long MONTHS = 2678400000L;
    public static final long YEARS = 31536000000L;
    MinMax dataLimits;
    DerivedInt precision = new DerivedInt(1, true);
    static final int MAX_PRECISION = 6;
    DerivedDouble numSpacing = new DerivedDouble(0.0, true);
    int logIncrement = 1;
    DerivedDouble tickSpacing = new DerivedDouble(0.0, true);
    public static final int AUTOMATIC = 0;
    public static final int MIN = 1;
    public static final int MAX = 2;
    public static final int ZERO = 3;
    public static final int VALUE_ANCHORED = 4;
    public static final int ORIGIN = 5;
    public static final int VALUE = 0;
    public static final int VALUE_LABELS = 1;
    public static final int TIME_LABELS = 2;
    public static final int POINT_LABELS = 3;
    int annotationMethod = 0;
    public static final int ROTATE_NONE = 0;
    public static final int ROTATE_90 = 1;
    public static final int ROTATE_180 = 2;
    public static final int ROTATE_270 = 3;
    transient int chartType;
    transient boolean isPrimary;
    transient JCAxis otherAxis;
    private transient AxisHandler axisHandler;
    private AnnotationHandler annoHandler = new AnnotationHandler(this);

    private void init() {
        this.setTitle(new JCAxisTitle());
        this.setName("Axis " + ++axisNum);
    }

    public JCAxis(JCChartArea jCChartArea, boolean bl, int n) {
        super(jCChartArea);
        this.isVertical = bl;
        this.annotationMethod = n;
        this.chartArea = jCChartArea;
        this.init();
    }

    public JCAxis() {
        this.init();
    }

    public void setParent(ChartCanvas chartCanvas) {
        if (this.parent == chartCanvas) {
            return;
        }
        super.setParent(chartCanvas);
        if (chartCanvas instanceof JCChartArea) {
            this.chartArea = (JCChartArea)chartCanvas;
        }
        if (this.title != null) {
            this.title.setParent(chartCanvas);
        }
        if (this.annoHandler != null && this.annoHandler.valueLabels != null) {
            int n = 0;
            while (n < this.annoHandler.valueLabels.size()) {
                JCValueLabel jCValueLabel = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n);
                jCValueLabel.getChartText().setParent(chartCanvas);
                ++n;
            }
        }
    }

    public boolean getGridIsShowing() {
        return this.gridIsShowing;
    }

    public void setGridIsShowing(boolean bl) {
        if (bl == this.gridIsShowing) {
            return;
        }
        this.gridIsShowing = bl;
        this.setChanged(true);
    }

    public double getGridSpacing() {
        return this.gridSpacing.value;
    }

    public synchronized void setGridSpacing(double d) {
        this.gridSpacing.value = d;
        this.gridSpacing.isDefault = false;
        this.setChanged(true);
    }

    public synchronized void setGridSpacingIsDefault(boolean bl) {
        if (this.gridSpacing.isDefault == bl) {
            return;
        }
        this.gridSpacing.isDefault = bl;
        this.setChanged(true);
    }

    public boolean getGridSpacingIsDefault() {
        return this.gridSpacing.isDefault;
    }

    public JCChartStyle getGridStyle() {
        if (this.gridStyle == null) {
            this.gridStyle = new JCChartStyle();
            this.gridStyle.setLineStyle(new JCLineStyle(1, this.getForeground(), 1));
        }
        return this.gridStyle;
    }

    public synchronized void setGridStyle(JCChartStyle jCChartStyle) {
        if (jCChartStyle == this.gridStyle) {
            return;
        }
        this.gridStyle = jCChartStyle;
        this.setChanged(true);
    }

    public synchronized void setIsLogarithmic(boolean bl) {
        if (this.isLogarithmic == bl) {
            return;
        }
        this.isLogarithmic = bl;
        this.axisHandler = null;
        this.setChanged(true);
    }

    public boolean getIsLogarithmic() {
        return this.isLogarithmic;
    }

    public synchronized void setIsEditable(boolean bl) {
        this.isEditable = bl;
        this.setChanged(true);
    }

    public boolean getIsEditable() {
        return this.isEditable;
    }

    public synchronized void setMin(double d) {
        this.min.value = d;
        this.min.isDefault = false;
        this.setChanged(true);
    }

    public double getMin() {
        return this.min.value;
    }

    public synchronized void setMinIsDefault(boolean bl) {
        if (this.min.isDefault == bl) {
            return;
        }
        this.min.isDefault = bl;
        this.setChanged(true);
    }

    public boolean getMinIsDefault() {
        return this.min.isDefault;
    }

    public synchronized void setMax(double d) {
        this.max.value = d;
        this.max.isDefault = false;
        this.setChanged(true);
    }

    public double getMax() {
        return this.max.value;
    }

    public synchronized void setMaxIsDefault(boolean bl) {
        if (this.max.isDefault == bl) {
            return;
        }
        this.max.isDefault = bl;
        this.setChanged(true);
    }

    public boolean getMaxIsDefault() {
        return this.max.isDefault;
    }

    public synchronized void setOrigin(double d) {
        this.origin.value = d;
        this.origin.isDefault = false;
        this.setChanged(true);
    }

    public double getOrigin() {
        return this.origin.value;
    }

    public synchronized void setOriginIsDefault(boolean bl) {
        if (this.origin.isDefault == bl) {
            return;
        }
        this.origin.isDefault = bl;
        this.parent.setChanged(true);
    }

    public boolean getOriginIsDefault() {
        return this.origin.isDefault;
    }

    public synchronized void setOriginPlacement(int n) {
        if (this.originPlacement.value == n) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.originPlacement.value = n;
                this.originPlacement.isDefault = false;
                this.setChanged(true);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid OriginPlacement in JCAxis");
    }

    public int getOriginPlacement() {
        return this.originPlacement.value;
    }

    public synchronized void setOriginPlacementIsDefault(boolean bl) {
        if (this.originPlacement.isDefault == bl) {
            return;
        }
        this.originPlacement.isDefault = bl;
        if (bl) {
            this.originPlacement.value = 0;
        }
        this.setChanged(true);
    }

    public boolean getOriginPlacementIsDefault() {
        return this.originPlacement.isDefault;
    }

    public JCAxisTitle getTitle() {
        if (this.title == null) {
            this.title = new JCAxisTitle();
            this.title.setParentAxis(this);
            this.title.setParent(this.parent);
        }
        return this.title;
    }

    public synchronized void setTitle(JCAxisTitle jCAxisTitle) {
        if (jCAxisTitle == null) {
            return;
        }
        this.title = jCAxisTitle;
        this.title.setParentAxis(this);
        this.title.setParent(this.parent);
        this.setChanged(true);
    }

    public synchronized void setIsReversed(boolean bl) {
        this.isReversed = bl;
        this.setChanged(true);
    }

    public boolean getIsReversed() {
        return this.isReversed;
    }

    public JCAxisFormula getFormula() {
        if (this.formula == null) {
            this.formula = new JCAxisFormula(this);
        }
        return this.formula;
    }

    public synchronized void setAnnotationRotation(int n) {
        if (n == this.annotationRotation) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.annotationRotation = n;
                this.setChanged(true);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid AnnotationRotation value in JCAxis");
    }

    public int getAnnotationRotation() {
        return this.annotationRotation;
    }

    public synchronized void setPlacement(int n) {
        if (this.placement.value == n) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                this.placement.value = n;
                this.placement.isDefault = false;
                this.setChanged(true);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid Placement value in JCAxis");
    }

    public synchronized void setPlacement(JCAxis jCAxis) {
        this.placementAxis = jCAxis;
        this.setPlacement(5);
        this.setChanged(true);
    }

    public synchronized void setPlacement(JCAxis jCAxis, double d) {
        this.placementAxis = jCAxis;
        this.placementLocation = d;
        this.setPlacement(4);
        this.setChanged(true);
    }

    public int getPlacement() {
        return this.placement.value;
    }

    public synchronized void setPlacementIsDefault(boolean bl) {
        if (this.placement.isDefault == bl) {
            return;
        }
        this.placement.isDefault = bl;
        if (bl) {
            this.placement.value = 0;
        }
        this.setChanged(true);
    }

    public boolean getPlacementIsDefault() {
        return this.placement.isDefault;
    }

    public synchronized void setPlacementAxis(JCAxis jCAxis) {
        this.placementAxis = jCAxis;
        this.setChanged(true);
    }

    public JCAxis getPlacementAxis() {
        return this.placementAxis;
    }

    public synchronized void setPlacementLocation(double d) {
        this.placementLocation = d;
        this.setChanged(true);
    }

    public double getPlacementLocation() {
        return this.placementLocation;
    }

    public synchronized void setAnnotationMethod(int n) {
        if (n == this.annotationMethod) {
            return;
        }
        switch (n) {
            case 3: {
                if (this.chartArea != null && !this.chartArea.isXAxis(this)) {
                    throw new IllegalArgumentException("Only X axes can use point labels");
                }
            }
            case 0: 
            case 1: 
            case 2: {
                this.annotationMethod = n;
                this.setChanged(true);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid AnnotationMethod value in JCAxis");
    }

    public int getAnnotationMethod() {
        return this.annotationMethod;
    }

    public synchronized void setPrecision(int n) {
        this.precision.value = n;
        this.precision.isDefault = false;
        this.setChanged(true);
    }

    public int getPrecision() {
        return this.precision.value;
    }

    public synchronized void setPrecisionIsDefault(boolean bl) {
        this.precision.isDefault = bl;
        this.setChanged(true);
    }

    public boolean getPrecisionIsDefault() {
        return this.precision.isDefault;
    }

    public synchronized void setNumSpacing(double d) {
        this.numSpacing.value = d;
        this.numSpacing.isDefault = false;
        this.setChanged(true);
    }

    public double getNumSpacing() {
        return this.numSpacing.value;
    }

    public synchronized void setNumSpacingIsDefault(boolean bl) {
        this.numSpacing.isDefault = bl;
        this.setChanged(true);
    }

    public boolean getNumSpacingIsDefault() {
        return this.numSpacing.isDefault;
    }

    public double getTickSpacing() {
        return this.tickSpacing.value;
    }

    public synchronized void setTickSpacing(double d) {
        this.tickSpacing.value = d;
        this.tickSpacing.isDefault = false;
        this.setChanged(true);
    }

    public synchronized void setTickSpacingIsDefault(boolean bl) {
        this.tickSpacing.isDefault = bl;
        this.setChanged(true);
    }

    public boolean getTickSpacingIsDefault() {
        return this.tickSpacing.isDefault;
    }

    public synchronized void setLabelGenerator(JCLabelGenerator jCLabelGenerator) {
        if (this.labelGenerator == jCLabelGenerator) {
            return;
        }
        this.labelGenerator = jCLabelGenerator;
        this.setChanged(true);
    }

    public JCLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public synchronized void setTimeUnit(long l) {
        if (this.timeUnit == l) {
            return;
        }
        if (l == 1000L || l == 60000L || l == 3600000L || l == 86400000L || l == 604800000L || l == 2678400000L || l == 31536000000L) {
            this.timeUnit = l;
            this.setChanged(true);
            return;
        }
        throw new IllegalArgumentException("Invalid TimeUnit value in JCAxis");
    }

    public long getTimeUnit() {
        return this.timeUnit;
    }

    public synchronized void setTimeBase(Date date) {
        if (date == null) {
            return;
        }
        if (this.timeBase != null && this.timeBase.equals(date)) {
            return;
        }
        this.timeBase = date;
        this.setChanged(true);
    }

    public Date getTimeBase() {
        if (this.timeBase == null) {
            this.timeBase = new Date();
        }
        return this.timeBase;
    }

    public synchronized void setTimeFormat(String string) {
        if (this.timeFormat.value != null && this.timeFormat.value.equals(string)) {
            return;
        }
        this.timeFormat.value = string;
        this.timeFormat.isDefault = false;
        this.setChanged(true);
    }

    public String getTimeFormat() {
        return this.timeFormat.value;
    }

    public synchronized void setTimeFormatIsDefault(boolean bl) {
        if (this.timeFormat.isDefault == bl) {
            return;
        }
        this.timeFormat.isDefault = bl;
        this.setChanged(true);
    }

    public boolean getTimeFormatIsDefault() {
        return this.timeFormat.isDefault;
    }

    public synchronized void setIsVertical(boolean bl) {
        if (this.isVertical == bl) {
            return;
        }
        this.isVertical = bl;
        this.setChanged(true);
    }

    public boolean getIsVertical() {
        return this.isVertical;
    }

    public synchronized void setGap(int n) {
        if (this.gap == n) {
            return;
        }
        if (n < 0) {
            throw new IllegalArgumentException("Gap in JCAxis must be >= 0");
        }
        this.gap = n;
        this.setChanged(true);
    }

    public int getGap() {
        return this.gap;
    }

    public JCValueLabel getValueLabel(double d) {
        JCValueLabel jCValueLabel = null;
        int n = 0;
        while (n < this.annoHandler.valueLabels.size()) {
            JCValueLabel jCValueLabel2 = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n);
            if (d == jCValueLabel2.value) {
                jCValueLabel = jCValueLabel2;
                break;
            }
            ++n;
        }
        return jCValueLabel;
    }

    public void addValueLabel(JCValueLabel jCValueLabel) {
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.annoHandler.valueLabels.size()) {
            JCValueLabel jCValueLabel2 = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n3);
            if (jCValueLabel2.value > jCValueLabel.value && n2 < 0) {
                n2 = n3;
            }
            if (jCValueLabel2.value == jCValueLabel.value) {
                n = n3;
                break;
            }
            ++n3;
        }
        if (n >= 0) {
            this.annoHandler.valueLabels.setElementAt(jCValueLabel, n);
        } else if (n2 >= 0) {
            this.annoHandler.valueLabels.insertElementAt(jCValueLabel, n2);
        } else {
            this.annoHandler.valueLabels.addElement(jCValueLabel);
        }
        jCValueLabel.setParent(this);
        this.setChanged(true);
    }

    public int toPixel(double d) {
        return this.getAxisHandler().toPixel(d);
    }

    public double toData(int n) {
        return this.getAxisHandler().toData(n);
    }

    public JCValueLabel[] getValueLabels() {
        if (this.annoHandler.valueLabels == null || this.annoHandler.valueLabels.size() == 0) {
            return null;
        }
        JCValueLabel[] jCValueLabelArray = new JCValueLabel[this.annoHandler.valueLabels.size()];
        int n = 0;
        while (n < jCValueLabelArray.length) {
            jCValueLabelArray[n] = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n);
            ++n;
        }
        return jCValueLabelArray;
    }

    public void setValueLabels(JCValueLabel[] jCValueLabelArray) {
        if (this.annotationMethod != 1) {
            return;
        }
        this.annoHandler.valueLabels = new JCVector();
        if (jCValueLabelArray == null) {
            return;
        }
        int n = 0;
        while (n < jCValueLabelArray.length) {
            if (jCValueLabelArray[n] != null) {
                jCValueLabelArray[n].setParent(this);
            }
            this.annoHandler.valueLabels.setElementAt(n, jCValueLabelArray[n]);
            ++n;
        }
        this.setChanged(true);
    }

    public JCValueLabel getValueLabels(int n) {
        if (this.annoHandler.valueLabels == null || this.annoHandler.valueLabels.size() == 0) {
            return null;
        }
        JCValueLabel jCValueLabel = null;
        try {
            jCValueLabel = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n);
        }
        catch (Exception exception) {}
        return jCValueLabel;
    }

    public synchronized void setValueLabels(int n, JCValueLabel jCValueLabel) {
        if (this.annotationMethod != 1) {
            return;
        }
        if (this.annoHandler.valueLabels == null) {
            this.annoHandler.valueLabels = new JCVector();
        }
        if (n < 0 || n > this.annoHandler.valueLabels.size()) {
            throw new IllegalArgumentException("Invalid ValueLabels index in JCAxis");
        }
        if (jCValueLabel != null) {
            jCValueLabel.setParent(this);
        }
        if (n < this.annoHandler.valueLabels.size()) {
            this.annoHandler.valueLabels.setElementAt(jCValueLabel, n);
        } else {
            this.annoHandler.valueLabels.insertElementAt(jCValueLabel, n);
        }
        this.setChanged(true);
    }

    public String toString() {
        String string = this.getName();
        if (string == null) {
            return "Unnamed " + (this.isVertical ? "Vertical" : "Horizontal") + " Axis";
        }
        return string;
    }

    public void draw(Graphics graphics) {
        if (!this.isShowing) {
            return;
        }
        this.axisDrawn = false;
        if (this.isVertical) {
            this.axisDrawn = this.drawVertical(graphics);
            return;
        }
        this.axisDrawn = this.drawHorizontal(graphics);
    }

    void drawAnnotationsAndTitle(Graphics graphics) {
        if (!this.isShowing) {
            return;
        }
        Graphics graphics2 = this.clipToExtents(graphics);
        if (this.axisDrawn) {
            this.annoHandler.draw(graphics2);
            if (this.title != null) {
                this.title.draw(graphics2);
            }
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (this.getLeft() == n && this.getTop() == n2 && this.getWidth() == n3 && this.getHeight() == n4) {
            return;
        }
        super.reshape(n, n2, n3, n4);
        this.setChanged(true, false);
        this.calcTransformation();
    }

    public void recalc() {
        this.setChanged(false, false);
    }

    public double dateToValue(Date date) {
        this.getTimeBase();
        return this.annoHandler.timeToData(date, this.timeUnit);
    }

    public Date valueToDate(double d) {
        this.getTimeBase();
        return this.annoHandler.dataToTime(d, this.timeUnit);
    }

    void preDraw(Graphics graphics) {
        if (!this.isShowing) {
            return;
        }
        if (this.isBar() && this.is3D()) {
            int[] nArray = new int[5];
            int[] nArray2 = new int[5];
            JCFillStyle jCFillStyle = new JCFillStyle(this.chartArea.getPlotArea().getBackground(), 1);
            if (this.isVertical) {
                nArray[0] = nArray[1] = this.linePosition();
                nArray2[0] = this.getTop() + this.getHeight();
                nArray2[1] = this.getTop();
                nArray[3] = nArray[2] = nArray[1] + this.chartArea.deltaX;
                nArray2[2] = nArray2[1] + this.chartArea.deltaY;
                nArray2[3] = nArray2[0] + this.chartArea.deltaY;
            } else {
                nArray[0] = this.getLeft() + this.getWidth();
                nArray[1] = this.getLeft();
                nArray2[0] = nArray2[1] = this.linePosition();
                nArray[2] = nArray[1] + this.chartArea.deltaX;
                nArray2[2] = nArray2[3] = nArray2[1] + this.chartArea.deltaY;
                nArray[3] = nArray[0] + this.chartArea.deltaX;
            }
            nArray[4] = nArray[0];
            nArray2[4] = nArray2[0];
            Polygon polygon = new Polygon();
            int n = 0;
            while (n < 5) {
                polygon.addPoint(nArray[n], nArray2[n]);
                ++n;
            }
            boolean bl = this.isPrimary && this.isVertical || !this.isPrimary && !this.isVertical;
            if (!this.isVertical && this.chartArea.deltaY <= 0 || this.isVertical && this.chartArea.deltaX <= 0) {
                jCFillStyle.fillOutlinePolygonHighlight(graphics, polygon, this.getForeground());
            } else {
                jCFillStyle.fillOutlinePolygonShadow(graphics, polygon, this.getForeground());
            }
            if (!this.chartArea.fastAction || !this.chartArea.inAction) {
                this.drawGridInTrough(graphics);
            }
        }
    }

    void clearLimits() {
        this.dataLimits = null;
    }

    void setLimits(MinMax minMax) {
        if (this.dataLimits == null) {
            this.dataLimits = new MinMax();
        }
        this.dataLimits.union(minMax);
        if (this.dataLimits.min > this.dataLimits.max) {
            this.dataLimits = null;
        }
    }

    void calcAxisParams(boolean bl) {
        boolean bl2;
        if (this.isVertical) {
            this.reshape(0, 0, 30, this.chartArea.size().height);
        } else {
            this.reshape(0, this.chartArea.size().height - 30, this.chartArea.size().width, 30);
        }
        this.chartType = -1;
        JCAxis jCAxis = this;
        boolean bl3 = bl2 = this.formula != null && this.formula.getOriginator() != null;
        if (bl2) {
            jCAxis = this.formula.getOriginator();
        }
        int n = 0;
        while (n < this.chartArea.chart.data.size()) {
            ChartDataView chartDataView = (ChartDataView)this.chartArea.chart.data.elementAt(n);
            if (chartDataView.xaxis == jCAxis) {
                this.chartType = chartDataView.getChartType();
                if (this.chartType == 9 || this.chartType == 10) {
                    this.hasBar = true;
                }
                this.isPrimary = !bl2;
                this.otherAxis = chartDataView.yaxis;
                break;
            }
            if (chartDataView.yaxis == jCAxis) {
                this.chartType = chartDataView.getChartType();
                if (this.chartType == 9 || this.chartType == 10) {
                    this.hasBar = true;
                }
                this.isPrimary = false;
                this.otherAxis = chartDataView.xaxis;
                break;
            }
            ++n;
        }
        this.getAxisHandler().calcParams();
        this.recalc();
    }

    void checkAnnotations() {
        if (!this.isShowing) {
            return;
        }
        this.annoHandler.checkAnnotations();
    }

    void calcAnchors() {
        if (!this.isShowing) {
            return;
        }
        this.annoHandler.calcAnchor();
        if (this.title.isShowing) {
            this.title.recalc();
            this.title.fixPlacement(this);
        }
    }

    void calcAnnotationExtents() {
        this.annoHandler.calcAnnotationExtents();
    }

    protected void adjustPlotRect() {
        if (!this.isShowing) {
            return;
        }
        int n = this.getLeft();
        int n2 = this.getTop();
        Rectangle rectangle = this.chartArea.plotRect;
        if (!this.isBar() && this.is3D()) {
            rectangle = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        boolean bl = false;
        if (this.otherAxis != null) {
            bl = this.otherAxis.isReversed;
        }
        if (this.isVertical) {
            if (this.annoHandler.extents.ortho > this.getWidth()) {
                this.resize(this.annoHandler.extents.ortho, this.getHeight());
            }
            if (this.annoHandler.realPlacement == 2 && !bl || this.annoHandler.realPlacement == 1 && bl) {
                rectangle.width -= this.getWidth();
                n = rectangle.x + rectangle.width;
            } else if (this.annoHandler.realPlacement == 1 && !bl || this.annoHandler.realPlacement == 2 && bl) {
                rectangle.width -= this.getWidth();
                n = rectangle.x;
                rectangle.x += this.getWidth();
            }
        } else {
            if (this.annoHandler.extents.ortho > this.getHeight()) {
                this.resize(this.getWidth(), this.annoHandler.extents.ortho);
            }
            if (this.annoHandler.realPlacement == 1 && !bl || this.annoHandler.realPlacement == 2 && bl) {
                rectangle.height -= this.getHeight();
                n2 = rectangle.y + rectangle.height;
            } else if (this.annoHandler.realPlacement == 2 && !bl || this.annoHandler.realPlacement == 1 && bl) {
                rectangle.height -= this.getHeight();
                n2 = rectangle.y;
                rectangle.y += this.getHeight();
            }
        }
        this.move(n, n2);
    }

    void adjustForOrthoExtent() {
        if (!this.isShowing) {
            return;
        }
        if (this.annoHandler.realPlacement == 1 || this.annoHandler.realPlacement == 2) {
            return;
        }
        if (this.placementAxis == null) {
            return;
        }
        Rectangle rectangle = this.chartArea.plotRect;
        Rectangle rectangle2 = this.chartArea.total;
        if (this.isVertical) {
            int n = this.annoHandler.realPlacement == 4 ? this.placementAxis.toPixel(this.placementLocation) : this.placementAxis.toPixel(this.placementAxis.origin.value);
            if (n < this.placementAxis.getLeft() || n > this.placementAxis.getLeft() + this.placementAxis.getWidth()) {
                return;
            }
            if (n < this.annoHandler.extents.ortho) {
                int n2 = this.annoHandler.extents.ortho - n;
                rectangle.width -= n2;
                rectangle.x += n2;
                this.resize(this.annoHandler.extents.ortho, this.getHeight());
                return;
            }
            if (rectangle2.width - n < this.annoHandler.extents.ortho) {
                int n3 = this.annoHandler.extents.ortho - (rectangle2.width - n);
                rectangle.width -= n3;
                this.resize(this.annoHandler.extents.ortho, this.getHeight());
                return;
            }
        } else {
            int n = this.annoHandler.realPlacement == 4 ? this.placementAxis.toPixel(this.placementLocation) : this.placementAxis.toPixel(this.placementAxis.origin.value);
            if (n < this.placementAxis.getTop() || n > this.placementAxis.getTop() + this.placementAxis.getHeight()) {
                return;
            }
            if (rectangle2.height - n < this.annoHandler.extents.ortho) {
                int n4 = this.annoHandler.extents.ortho - (rectangle2.height - n);
                rectangle.height -= n4;
                this.resize(this.getWidth(), this.annoHandler.extents.ortho);
                return;
            }
            if (n < this.annoHandler.extents.ortho) {
                int n5 = this.annoHandler.extents.ortho - n;
                rectangle.height -= n5;
                rectangle.y += n5;
                this.resize(this.getWidth(), this.annoHandler.extents.ortho);
            }
        }
    }

    void layoutAxis(boolean bl) {
        int n;
        if (!this.isShowing) {
            return;
        }
        int n2 = Math.max(-this.chartArea.deltaX, 0);
        int n3 = Math.max(-this.chartArea.deltaY, 0);
        int n4 = this.chartArea.deltaX;
        int n5 = this.chartArea.deltaY;
        int n6 = n = bl ? 1 : 0;
        if (this.isVertical) {
            if (!this.is3D()) {
                this.reshape(this.getLeft(), this.chartArea.plotRect.y, this.getWidth(), this.chartArea.plotRect.height);
                return;
            }
            if (this.isBar()) {
                if (this.getLeft() < this.chartArea.plotRect.x) {
                    this.reshape(this.getLeft() + n2 * n, this.chartArea.plotRect.y + n3, this.getWidth(), this.chartArea.plotRect.height - JCChartUtil.abs(n5));
                    return;
                }
                n2 = Math.max(this.chartArea.deltaX, 0);
                this.reshape(this.getLeft() - n2 * n, this.chartArea.plotRect.y + n3, this.getWidth(), this.chartArea.plotRect.height - JCChartUtil.abs(n5));
                return;
            }
            n3 = Math.max(this.chartArea.deltaY, 0);
            if (this.getLeft() <= this.chartArea.plotRect.x) {
                n2 = Math.max(this.chartArea.deltaX, 0);
                this.reshape(this.chartArea.plotRect.x + n2 * n - this.getWidth(), this.chartArea.plotRect.y + n3, this.getWidth(), this.chartArea.plotRect.height - JCChartUtil.abs(n5));
                return;
            }
            this.reshape(this.chartArea.plotRect.x + this.chartArea.plotRect.width - n2 * n, this.chartArea.plotRect.y + n3, this.getWidth(), this.chartArea.plotRect.height - JCChartUtil.abs(n5));
            return;
        }
        if (!this.is3D()) {
            this.reshape(this.chartArea.plotRect.x, this.getTop(), this.chartArea.plotRect.width, this.getHeight());
            return;
        }
        if (this.isBar()) {
            if (this.getTop() <= this.chartArea.plotRect.y) {
                this.reshape(this.chartArea.plotRect.x + n2, this.getTop() + n3 * n, this.chartArea.plotRect.width - JCChartUtil.abs(n4), this.getHeight());
                return;
            }
            n3 = Math.max(this.chartArea.deltaY, 0);
            this.reshape(this.chartArea.plotRect.x + n2, this.getTop() - n3 * n, this.chartArea.plotRect.width - JCChartUtil.abs(n4), this.getHeight());
            return;
        }
        n2 = Math.max(this.chartArea.deltaX, 0);
        if (this.getTop() <= this.chartArea.plotRect.y) {
            n3 = Math.max(this.chartArea.deltaY, 0);
            this.reshape(this.chartArea.plotRect.x + n2, this.chartArea.plotRect.y + n3 * n - this.getHeight(), this.chartArea.plotRect.width - JCChartUtil.abs(n4), this.getHeight());
            return;
        }
        this.reshape(this.chartArea.plotRect.x + n2, this.chartArea.plotRect.y + this.chartArea.plotRect.height - n3 * n, this.chartArea.plotRect.width - JCChartUtil.abs(n4), this.getHeight());
    }

    void layoutOrigin() {
        if (!this.isShowing) {
            return;
        }
        if (this.annoHandler.realPlacement != 5 && this.annoHandler.realPlacement != 4) {
            return;
        }
        if (this.placementAxis == null) {
            this.placementAxis = this.otherAxis;
        }
        if (this.placementAxis == null) {
            return;
        }
        double d = this.annoHandler.realPlacement == 4 ? this.placementLocation : this.placementAxis.origin.value;
        int n = this.placementAxis.toPixel(d);
        if (this.isVertical) {
            if (this.annoHandler.anchor == 1) {
                this.move(n, this.getTop());
                return;
            }
            this.move(n - this.getWidth(), this.getTop());
            return;
        }
        if (this.annoHandler.anchor == 16) {
            this.move(this.getLeft(), n - this.getHeight());
            return;
        }
        this.move(this.getLeft(), n);
    }

    void layoutAnnotations() {
        if (!this.isShowing) {
            return;
        }
        this.annoHandler.layout();
        if (this.title != null) {
            this.title.layout();
        }
    }

    int pixelLength() {
        if (this.isVertical) {
            return this.getHeight();
        }
        return this.getWidth();
    }

    int pixelStart() {
        if (this.isVertical) {
            return -this.getTop();
        }
        return this.getLeft();
    }

    void calcTransformation() {
        this.getAxisHandler().calcTransformation();
    }

    int linePosition() {
        int n = this.isVertical ? (this.annoHandler.anchor == 2 ? this.getLeft() + this.getWidth() : (this.annoHandler.anchor == 1 ? this.getLeft() : this.getLeft() + this.getWidth() / 2)) : (this.annoHandler.anchor == 16 ? this.getTop() + this.getHeight() : (this.annoHandler.anchor == 32 ? this.getTop() : this.getTop() + this.getHeight() / 2));
        return n;
    }

    void makeAnnotations() {
        this.annoHandler.makeAnnotations();
    }

    AxisHandler getAxisHandler() {
        if (this.axisHandler == null) {
            this.axisHandler = AxisHandler.makeAxisHandler(this);
        }
        return this.axisHandler;
    }

    Extents getExtents() {
        return this.annoHandler.extents;
    }

    JCVector getAnnotations() {
        return this.annoHandler.valueLabels;
    }

    int getAdjustedRealPlacement() {
        if (this.otherAxis != null && this.otherAxis.isReversed) {
            if (this.annoHandler.realPlacement == 1) {
                return 2;
            }
            return 1;
        }
        return this.annoHandler.realPlacement;
    }

    int getAnnotationAnchor() {
        return this.annoHandler.anchor;
    }

    double firstInc(double d) {
        double d2 = this.min.value;
        if (d == 0.0) {
            return d2;
        }
        int n = (int)Math.ceil((this.min.value - (d2 = JCChartUtil.precCorrect(this.precision.value, d2))) / d);
        if (n < 0) {
            return d2;
        }
        double d3 = d2 + d * (double)n;
        if ((d3 = JCChartUtil.precCorrect(this.precision.value, d3)) > this.max.value) {
            return d2;
        }
        return d3;
    }

    double range() {
        return this.getAxisHandler().range();
    }

    void translate(double d) {
        this.getAxisHandler().translate(d);
        this.setChanged(true, false);
    }

    private boolean isBar() {
        return this.hasBar;
    }

    private boolean is3D() {
        return this.chartArea != null && this.chartArea.draw3D;
    }

    private double dataLength() {
        return this.max.value - this.min.value;
    }

    void drawGrid(Graphics graphics) {
        if (!this.gridIsShowing) {
            return;
        }
        if (this.gridSpacing.isDefault) {
            this.drawGridLinesAtLabels(graphics, false);
            return;
        }
        this.drawLinearGridLines(graphics, false);
    }

    private void drawGridInTrough(Graphics graphics) {
        if (!this.gridIsShowing) {
            return;
        }
        if (this.gridSpacing.isDefault) {
            this.drawGridLinesAtLabels(graphics, true);
            return;
        }
        this.drawLinearGridLines(graphics, true);
    }

    private void drawGridLine(Graphics graphics, JCLineStyle jCLineStyle, double d) {
        int n = this.toPixel(d);
        Rectangle rectangle = this.chartArea.plotRect;
        int n2 = this.chartArea.deltaX;
        int n3 = this.chartArea.deltaY;
        if (this.isVertical) {
            if (this.is3D() && this.isBar()) {
                int n4 = this.linePosition();
                jCLineStyle.draw(graphics, n4, n, n4 + n2, n + n3);
                if (n2 < 0) {
                    jCLineStyle.draw(graphics, rectangle.x, n + n3, rectangle.x + rectangle.width + n2, n + n3);
                    return;
                }
                jCLineStyle.draw(graphics, rectangle.x + n2, n + n3, rectangle.x + rectangle.width, n + n3);
                return;
            }
            jCLineStyle.draw(graphics, rectangle.x, n, rectangle.x + rectangle.width, n);
            return;
        }
        if (this.is3D() && this.isBar()) {
            int n5 = this.linePosition();
            jCLineStyle.draw(graphics, n, n5, n + n2, n5 + n3);
            if (n3 < 0) {
                jCLineStyle.draw(graphics, n2 + n, rectangle.y, n2 + n, rectangle.y + rectangle.height + n3);
                return;
            }
            jCLineStyle.draw(graphics, n2 + n, rectangle.y + n3, n2 + n, rectangle.y + rectangle.height);
            return;
        }
        jCLineStyle.draw(graphics, n, rectangle.y, n, rectangle.y + rectangle.height);
    }

    private void drawGridLineInTrough(Graphics graphics, JCLineStyle jCLineStyle, double d) {
        int n = this.toPixel(d);
        int n2 = this.chartArea.deltaX;
        int n3 = this.chartArea.deltaY;
        if (this.isVertical) {
            if (this.is3D() && this.isBar()) {
                int n4 = this.linePosition();
                jCLineStyle.draw(graphics, n4, n, n4 + n2, n + n3);
                return;
            }
        } else if (this.is3D() && this.isBar()) {
            int n5 = this.linePosition();
            jCLineStyle.draw(graphics, n, n5, n + n2, n5 + n3);
        }
    }

    private void drawLinearGridLines(Graphics graphics, boolean bl) {
        double d = this.gridSpacing.value;
        int n = this.pixelLength();
        double d2 = this.dataLength();
        double d3 = d / 2.0;
        if (d3 < 0.0) {
            d3 = -d3;
        }
        if (d * (double)n / d2 + 0.5 < 2.0) {
            if (d <= 0.0) {
                this.setGridIsShowing(false);
                this.setGridSpacingIsDefault(true);
                return;
            }
            ErrorDialog.raise("Provided grid spacing is too small to show up");
            return;
        }
        JCLineStyle jCLineStyle = this.getGridStyle().getLineStyle();
        double d4 = this.min.value;
        while (d4 < this.max.value + d3) {
            if (bl) {
                this.drawGridLineInTrough(graphics, jCLineStyle, d4);
            } else {
                this.drawGridLine(graphics, jCLineStyle, d4);
            }
            d4 += d;
        }
    }

    private void drawGridLinesAtLabels(Graphics graphics, boolean bl) {
        JCLineStyle jCLineStyle = this.getGridStyle().getLineStyle();
        int n = 0;
        while (n < this.annoHandler.valueLabels.size()) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n);
            ChartText chartText = jCValueLabel.getChartText();
            if (chartText.isShowing) {
                if (bl) {
                    this.drawGridLineInTrough(graphics, jCLineStyle, jCValueLabel.value);
                } else {
                    this.drawGridLine(graphics, jCLineStyle, jCValueLabel.value);
                }
            }
            ++n;
        }
    }

    private boolean drawVertical(Graphics graphics) {
        int n = this.getHeight();
        int n2 = this.getTop();
        int n3 = this.linePosition();
        if (!(this.annoHandler.realPlacement != 5 && this.annoHandler.realPlacement != 4 || n3 <= this.chartArea.plotRect.x + this.chartArea.plotRect.width && n3 >= this.chartArea.plotRect.x)) {
            return false;
        }
        if (graphics.getColor() != this.getForeground()) {
            graphics.setColor(this.getForeground());
        }
        graphics.drawLine(n3, n2, n3, n2 + n);
        this.getAxisHandler().drawTicks(graphics);
        return true;
    }

    private boolean drawHorizontal(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getLeft();
        int n3 = this.linePosition();
        if (!(this.annoHandler.realPlacement != 5 && this.annoHandler.realPlacement != 4 || n3 <= this.chartArea.plotRect.y + this.chartArea.plotRect.height && n3 >= this.chartArea.plotRect.y)) {
            return false;
        }
        if (graphics.getColor() != this.getForeground()) {
            graphics.setColor(this.getForeground());
        }
        graphics.drawLine(n2, n3, n2 + n, n3);
        this.getAxisHandler().drawTicks(graphics);
        return true;
    }

    private Graphics clipToExtents(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        Extents extents = this.getExtents();
        if (this.isVertical) {
            graphics2.clipRect(0, this.getTop() - extents.minor, this.chartArea.getDrawingArea().width + 1, this.getHeight() + extents.major + extents.minor + 1);
        } else {
            graphics2.clipRect(this.getLeft() - extents.minor, 0, this.getWidth() + extents.major + extents.minor + 1, this.chartArea.getDrawingArea().height + 1);
        }
        return graphics2;
    }
}

